/*-----------------------------------------------------------------------*
 * filename - setenvp.c
 *
 * function(s)
 *      _lock_env       - lock the environment semaphore
 *      _wlock_env      - lock the wide-character environment semaphore
 *      _unlock_env     - unlock the environment semaphore
 *      _wunlock_env    - unlock the wide-character environment semaphore
 *      _setenvp        - set up environment strings
 *      _wsetenvp       - set up wide-character environment strings
 *      _extenvp        - clean up environment strings
 *      _wextenvp       - clean up wide-character environment strings
 *-----------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 11.0
 *
 *      Copyright (c) 1991, 2004 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */

/* $Revision: 9.6 $        */

#include <string.h>
#include <stdlib.h>
#include <_io.h>
#include <_thread.h>
#include <tchar.h>
#include <_tchar.h>
#include <_ostype.h>

/*----------------------------------------------------------------------
 * Public variables
 */
int _tsetenvp__ = 0;                    /* satisfy ext. ref. generated by BCC32 */
static _TCHAR *              _tenvcopy; /* Our inital copy of the master table */
_TCHAR ** _RTLENTRY _EXPDATA _tenviron; /* pointer to array of env. strings */
int       _RTLENTRY _EXPDATA _tenvsize; /* number of env strings allocated
                                           includes the 4 extra at the end
                                           for expansion. (Does not include
                                           the fifth extra one which is always
                                           NULL at the absolute end). To use
                                           the extra slots, check to see if
                                           environ[envsize-4,3,2 or 1] is NULL.
                                           If so, use it, if not go to the
                                           next.  If you run out, re-allocate
                                           and re-assign the block leaving
                                           room for another 4 extra slots.
                                         */

lock_t _tenv_lock;                       /* semaphore for env. strings */

/*----------------------------------------------------------------------
 * External variables
 */
extern _TCHAR **_tC0environ;             /* startup's copy of environ */
extern _TCHAR *_tosenv;                  /* pointer to NT environment data */

#ifdef _MT

/*---------------------------------------------------------------------*

Name            _lock_env, _wlock_env - lock the environment semaphore

Usage           void _lock_env(void);
                void _wlock_env(void);

Prototype in

Related
functions usage void _unlock_env(void);
                void _wunlock_env(void);

Description     This function locks the semaphore that governs
                access to the environment strings.

Return value    None.

*---------------------------------------------------------------------*/

void _tlock_env(void)
{
    _lock(_tenv_lock,"locking environment lock");
}

/*---------------------------------------------------------------------*

Name            _unlock_env, _wunlock_env - unlock the environment semaphore

Usage           void _unlock_env(void);
                void _wunlock_env(void);

Prototype in

Related
functions usage void _unlock_env(void);
                void _wunlock_env(void);

Description     This function unlocks the global lock that governs
                access to the environment strings.

Return value    None.

*---------------------------------------------------------------------*/

void _tunlock_env(void)
{
    _unlock(_tenv_lock,"unlocking environment lock");
}

#endif  /* _MT */

/*---------------------------------------------------------------------*

Name            _extenvp, _wextenvp - clean up environment memory block

Usage           void _extenvp(void);
                void _wextenvp(void);

Description     This function is called at exit time to free the memory
                for the environment block that was allocated at
                startup time.

Return value    None.

*---------------------------------------------------------------------*/

static void _textenvp(void)
{
#ifndef _UNICODE
#   pragma exit _extenvp 3 /* Finalization of envp routines */
#else
#   pragma exit _wextenvp 3 /* Finalization of wide envp routines */
#endif

#if defined(_UNICODE)
    /* If Unicode version then ignore for platforms that don't support
     * it.  We have to do runtime check for RTLDLL.
     */
    if (_ostype & _WINNT)
    {
#endif
    if (_tenvcopy)
        free ((void *)_tenvcopy);
    if (_tenviron)
        free ((void *)_tenviron);

    _tenvcopy = NULL;
    _tenviron = NULL;
#if defined(_UNICODE)
    }
#endif
}


/*---------------------------------------------------------------------*

Name            _expandblock, _wexpandblock - expands the environ block to hold
                               more entries.

Usage           int _expandblock(void);
                int _wexpandblock(void);

Description     This is a helper function which expands the size of
                the environ block to hold the number of strings that
                are currently in the environ array (including the
                extra slots if used).  If the main environ variable
                hasn't been allocated, then this routine will copy the
                strings from _osenv, else it will copy them from the
                previous environ.

Return value    1 for success, 0 for out-of-memory

*---------------------------------------------------------------------*/
int _texpandblock (void)
{
    /*
        This function is only called from routines which have already locked
        the MT lock for access to the global vars.
     */
    _TCHAR *p, **e, **pt;
    int n, len, total;

    if (!_tenviron)
    {
        if (!_tosenv)
            if ((_tosenv = GetEnvironmentStrings()) == NULL)
                _ErrorExit ("GetEnvironmentStrings failed");

        /* For the first time called, get the strings from the master
               environment table: _osenv/_wosenv
            */

        /* First, count the strings in the master environment.
         */
        for (total=0, n = 0, p = _tosenv; (len = _tcslen(p)) != 0; n++, p += len + 1)
            total += (len + 1); /* string + null */

        /* Allocate the block to hold a copy of the master block. Note that
           the master block has an extra \0 byte at the end of the list.
        */

        if ((_tenvcopy = (_TCHAR *) malloc ((total+1)*sizeof(_TCHAR))) == NULL)
            return 0;

        memcpy ((_TCHAR *)_tenvcopy, _tosenv, (total+1)*sizeof(_TCHAR));
    }
    else
    {
        /* Otherwise, count the strings in the previous environ block.
         */
        for (n = 0, pt=_tenviron; *pt ; n++, pt++)
        {
            if (_tcslen (*pt) == 0)
                n--;
        }

    }

    _tenvsize = n + 4;

    /* Allocate space for the array of pointers.  Include 4 extra slots
     * for later expansion with putenv() and another extra one for a NULL
     * terminator.
     */
    if ((e = calloc((_tenvsize+1),sizeof(char*))) == NULL)
        return 0;

    /* Save a pointer to each string in the environ array.
     */

    if (!_tenviron)
    {
        for (n = 0, p = _tenvcopy; (len = _tcslen(p)) != 0; n++, p += len + 1)
        {
            e[n] = p;
        }
    }
    else
    {
        for (n = 0, pt=_tenviron; *pt ; n++, pt++)
        {
            if (_tcslen (*pt) != 0)
                e[n] = *pt;
            else
                n--;
            //                _tcsdec(n,n);  // If it's a null string, adjust the index
        }

    }

    if (_tenviron)
        free (_tenviron);

    _tenviron = e;
    return 1;
}


/*---------------------------------------------------------------------*

Name            _setenvp, _wsetenvp - set up environment strings

Usage           void _setenvp(void);
                void _wsetenvp(void);

Description     This function is called at startup time.
                It saves copies of each environment string,
                and creates an array of pointers to these strings.
                The pointer to the array is saved in both environ
                and _C0environ.  It assumes that a pointer to
                the environment has already been placed in _osenv
                by the startup code.

Return value    None.

*---------------------------------------------------------------------*/

static void _tsetenvp(void)
{
#ifndef _UNICODE
#   pragma startup _setenvp 3 /* Initialization of envp routines */
#else
#   pragma startup _wsetenvp 3 /* Initialization of wide envp routines */
#endif

#if defined(_UNICODE)
    /* If Unicode version then ignore for platforms that don't support
     * it.  We have to do runtime check for RTLDLL.
     */
    if (_ostype & _WINNT)
    {
#endif
    /* call _expandblock to initialize the environ block
     */
    if (_texpandblock() == 0)
    {
        _ErrorExit ("Could not allocate memory for environment block");
        return;
    }

    /* The startup code passes _C0environ to main().
     */
    _tC0environ = _tenviron;

    /* Create the lock used to govern access to the environment strings.
     */
    _create_lock(&_tenv_lock,"creating environment lock");
#if defined(_UNICODE)
    }
#endif
}


